/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.ui.swt.wizard.diskimage;

import com.webcodepro.applecommander.ui.UiBundle;
import com.webcodepro.applecommander.ui.swt.wizard.WizardPane;
import com.webcodepro.applecommander.ui.swt.wizard.diskimage.DiskImageNamePane;
import com.webcodepro.applecommander.ui.swt.wizard.diskimage.DiskImageSizePane;
import com.webcodepro.applecommander.ui.swt.wizard.diskimage.DiskImageWizard;
import com.webcodepro.applecommander.util.TextBundle;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class DiskImageFormatPane
extends WizardPane {
    private TextBundle textBundle = UiBundle.getInstance();
    private DiskImageWizard wizard;
    private Composite control;
    private Composite parent;

    public DiskImageFormatPane(Composite parent, DiskImageWizard wizard) {
        this.parent = parent;
        this.wizard = wizard;
    }

    @Override
    public WizardPane getNextPane() {
        switch (this.wizard.getFormat()) {
            case 1: 
            case 5: 
            case 7: {
                this.wizard.setOrder(1);
                this.wizard.setSize(143360);
                return new DiskImageNamePane(this.parent, this.wizard);
            }
            case 2: {
                this.wizard.setOrder(1);
                this.wizard.setSize(819264);
                return new DiskImageNamePane(this.parent, this.wizard);
            }
            case 6: {
                this.wizard.setOrder(2);
                this.wizard.setSize(819264);
                return new DiskImageNamePane(this.parent, this.wizard);
            }
            case 3: 
            case 4: {
                this.wizard.setOrder(2);
                return new DiskImageSizePane(this.parent, this.wizard);
            }
        }
        return null;
    }

    @Override
    public void open() {
        this.control = new Composite(this.parent, 0);
        this.wizard.enableNextButton(true);
        this.wizard.enableFinishButton(false);
        RowLayout layout = new RowLayout(512);
        layout.justify = true;
        layout.marginBottom = 5;
        layout.marginLeft = 5;
        layout.marginRight = 5;
        layout.marginTop = 5;
        layout.spacing = 3;
        this.control.setLayout(layout);
        Label label = new Label(this.control, 64);
        label.setText(this.textBundle.get("DiskImageFormatPrompt"));
        RowLayout subpanelLayout = new RowLayout(512);
        subpanelLayout.justify = true;
        subpanelLayout.spacing = 3;
        Composite buttonSubpanel = new Composite(this.control, 0);
        buttonSubpanel.setLayout(subpanelLayout);
        this.createRadioButton(buttonSubpanel, this.textBundle.get("Dos"), 1, this.textBundle.get("DiskImageFormatDosTooltip"));
        this.createRadioButton(buttonSubpanel, this.textBundle.get("Unidos"), 2, this.textBundle.get("DiskImageFormatUnidosTooltip"));
        this.createRadioButton(buttonSubpanel, this.textBundle.get("Ozdos"), 6, this.textBundle.get("DiskImageFormatOzdosTooltip"));
        this.createRadioButton(buttonSubpanel, this.textBundle.get("Prodos"), 3, this.textBundle.get("DiskImageFormatProdosTooltip"));
        this.createRadioButton(buttonSubpanel, this.textBundle.get("Pascal"), 4, this.textBundle.get("DiskImageFormatPascalTooltip"));
        this.createRadioButton(buttonSubpanel, this.textBundle.get("Rdos"), 5, this.textBundle.get("DiskImageFormatRdosTooltip"));
        this.createRadioButton(buttonSubpanel, this.textBundle.get("Cpm"), 7, this.textBundle.get("DiskImageFormatCpmTooltip"));
        this.control.pack();
    }

    protected void createRadioButton(Composite composite, String label, final int format, String helpText) {
        Button button = new Button(composite, 16);
        button.setText(label);
        button.setSelection(this.wizard.getFormat() == format);
        button.setToolTipText(helpText);
        button.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                DiskImageFormatPane.this.getWizard().setFormat(format);
            }
        });
    }

    @Override
    public void dispose() {
        this.control.dispose();
    }

    protected DiskImageWizard getWizard() {
        return this.wizard;
    }
}

